/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include <csl_clkrst.h>
#include <soc.h>

#define ENABLE(CLK) (CSL_CLKRST_MODULE_##CLK)

void
enable_peripheral_clk()
{
    CSL_ClkrstObj clkrstObj;
    CSL_ClkrstHandle hClkrst = NULL;
    CSL_ClkrstHwSetup clkSetup = CSL_CLKRST_HWSETUP_DEFAULTS;
    CSL_ClkrstModule clkEn;
    CSL_Status csl_status;

    /* ******************--- Clock Cofiguration---****************** */

    /* To Initialise Clkrst CSL */
    CSL_clkrstInit(NULL);

    /* To Open Clkrst CSL */
    hClkrst = CSL_clkrstOpen(&clkrstObj, CSL_CLKRST, NULL, &csl_status);

    /* To Setup the Clkrst CSL */
    CSL_clkrstHwSetup(hClkrst, &clkSetup);

    /* Variable to Enable the Desired Clock */
    clkEn = (CSL_ClkrstModule) (ENABLE(TIM) | ENABLE(XORP) | ENABLE(PER));

    /* To Enable the Clocks */
    CSL_clkrstHwControl(hClkrst, CSL_CLKRST_CMD_CLK_ENABLE,
                        ((Uint16 *) & clkEn));

    /* ******************---End of Clock Cofiguration---****************** */

    printf("Enable pierpheral clock !\n");
}
